// AnalogDeviceVideoEncoderGraph.cpp: implementation of the CAnalogDeviceVideoEncoderGraph class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "AnalogDeviceVideoEncoderGraph.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

static const GUID PROPSETID_AMEBDAD_CUSTOM_PROP = { 0xD1E5209F, 0x68FD, 0x4529, 0xBE, 0xE0, 0x5E, 0x7A, 0x1F, 0x47, 0x92, 0x00 }; // CUSTOM PROPERITY { D1E5209F-68FD-4529-BEE0-5E7A1F4792XX }

VOID CAnalogDeviceVideoEncoderGraph::SC_DEBUG( CHAR * fmt, ... )
{
	CHAR pszDebugDumpMessage[ MAX_PATH ] = "[SC5C0] [00000000] ";

	va_list marker;

	va_start( marker, fmt );

	StringCbPrintfA( pszDebugDumpMessage + 8, sizeof(pszDebugDumpMessage), "[%08X] ", this );

	StringCbVPrintfA( pszDebugDumpMessage + 8 + 1 + 10, sizeof(pszDebugDumpMessage), fmt, marker );

	va_end( marker );

	StringCbCatA( pszDebugDumpMessage, sizeof(pszDebugDumpMessage), "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnalogDeviceVideoEncoderGraph::CAnalogDeviceVideoEncoderGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::CAnalogDeviceVideoEncoderGraph()" );

	m_pCaptureSourceBaseFilter = NULL;

	m_pSampleGrabberBaseFilter = NULL;

	m_pKsPropertySet = NULL;

	m_sKsPropertySetGUID = GUID_NULL;

	m_pAMAnalogVideoDecoder = NULL;

	m_pAMStreamConfig = NULL;

	m_pAMVideoCompression = NULL;

	m_pSampleGrabber = NULL;

	m_oSampleGrabber.SetCallback( NULL, NULL );

	m_nColorSpaceType = 0x00000000;

	m_nWidth = 0;

	m_nHeight = 0;

	m_nBitCount = 0;

	m_dFrameRate = 0.0;
}

CAnalogDeviceVideoEncoderGraph::~CAnalogDeviceVideoEncoderGraph()
{
//	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::~CAnalogDeviceVideoEncoderGraph()" );

	CAnalogDeviceVideoEncoderGraph::Close( FALSE );
}

BOOL CAnalogDeviceVideoEncoderGraph::Close( BOOL bDumpDebugMessage )
{
	if( bDumpDebugMessage ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Close()" ); }

	if( m_pCommonMediaControl ) { if( GetState() == State_Running ) { Stop(); } }

	if( m_pCommonMediaControl ) { if( GetState() == State_Paused ) { Stop(); } }

	RELEASE( m_pKsPropertySet );

	RELEASE( m_pAMAnalogVideoDecoder );

	RELEASE( m_pAMStreamConfig );

	RELEASE( m_pAMVideoCompression );

	RELEASE( m_pSampleGrabber );

	RELEASE( m_pCaptureSourceBaseFilter );

	RELEASE( m_pSampleGrabberBaseFilter );

	m_oSampleGrabber.SetCallback( NULL, NULL );

	m_sKsPropertySetGUID = GUID_NULL;

	m_nColorSpaceType = 0x00000000;

	m_nWidth = 0;

	m_nHeight = 0;

	m_nBitCount = 0;

	m_dFrameRate = 0.0;

	return CloseGraphBuilder( bDumpDebugMessage );
}

BOOL CAnalogDeviceVideoEncoderGraph::Create( PWSTR              pwszDevName, 
									 
											 UINT               iDevNum, 
											  
											 PF_BUFFER_CALLBACK pBufferCB, 
											 
											 PVOID              pUserData )
{
	WCHAR pwszFilterNameBuffer[ 256 ];

	StringCchPrintfW( pwszFilterNameBuffer, 256, L"%ws, Analog Capture (#%02d)", pwszDevName, iDevNum + 1 );

	// CREATE GRAPH BUILDER RESOURCE
	//
	if( FALSE == CreateGraphBuilder() ) return FALSE; 

	// FIND/ADD CAPTURE SOURCE FILTER INTO GRAPH
	//
	if( FALSE == FindFilter( &CLSID_VideoInputDeviceCategory, pwszFilterNameBuffer, 0, &m_pCaptureSourceBaseFilter, pwszFilterNameBuffer, 256 ) ) return FALSE;

	if( FALSE == AddFilter( m_pCaptureSourceBaseFilter, pwszFilterNameBuffer ) ) return FALSE;

	if( FAILED(CoCreateInstance( CLSID_SampleGrabber, NULL, CLSCTX_INPROC_SERVER, IID_IBaseFilter, (VOID **)(&m_pSampleGrabberBaseFilter) )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( CoCreateInstance(CLSID_SampleGrabber) ) ERROR!!" ); return FALSE; }

	if( FALSE == AddFilter( m_pSampleGrabberBaseFilter, L"Sample Grabber" ) ) return FALSE;

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( NULL, NULL, m_pSampleGrabberBaseFilter, IID_ISampleGrabber, (VOID **)(&m_pSampleGrabber) )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( FindInterface(IID_ISampleGrabber) )" ); }

	if( NULL != m_pSampleGrabber ) {

		if( FAILED(m_pSampleGrabber->SetOneShot( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( ISampleGrabber::SetOneShot() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pSampleGrabber->SetBufferSamples( FALSE )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( ISampleGrabber::SetBufferSamples() ) ERROR!!" ); return FALSE; }

		if( FAILED(m_pSampleGrabber->SetCallback( &m_oSampleGrabber, 0 )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( ISampleGrabber::SetCallback() ) ERROR!!" ); return FALSE; }

		m_oSampleGrabber.SetCallback( pBufferCB, pUserData );

		m_oSampleGrabber.SetDeviceType( 0x00000002 );
	}
	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface(                  NULL, NULL, m_pCaptureSourceBaseFilter, IID_IKsPropertySet,        (VOID **)(&m_pKsPropertySet)        )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( FindInterface(IID_IKsPropertySet) )" ); }

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface(                  NULL, NULL, m_pCaptureSourceBaseFilter, IID_IAMAnalogVideoDecoder, (VOID **)(&m_pAMAnalogVideoDecoder) )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( FindInterface(IID_IAMAnalogVideoDecoder) )" ); }

	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( &LOOK_DOWNSTREAM_ONLY, NULL, m_pCaptureSourceBaseFilter, IID_IAMStreamConfig,       (VOID **)(&m_pAMStreamConfig)       )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( FindInterface(IID_IAMStreamConfig) )" ); }
		
//	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface(                  NULL, NULL, m_pCaptureSourceBaseFilter, IID_IAMVideoCompression,   (VOID **)(&m_pAMVideoCompression)   )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( FindInterface(IID_IAMVideoCompression) )" ); } // MOVE AFTER CONNECTION

	if( NULL != m_pKsPropertySet ) {

		GUID guid = PROPSETID_AMEBDAD_CUSTOM_PROP;

		for( ULONG i = 0 ; i < 36 ; i++ ) { 
		
			DWORD dwDeviceSerialNumber = 0x00000000;

			DWORD cbBytes = 0x00000000;

			guid.Data4[ 7 ] = (BYTE)(i);

			if( SUCCEEDED(m_pKsPropertySet->Get( guid, 0, NULL, 0, &dwDeviceSerialNumber, sizeof(ULONG), &cbBytes )) ) { 
				
				SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( IKsPropertySet::GetDeviceSerialNumber( 0x%08X ) )", dwDeviceSerialNumber );

				m_sKsPropertySetGUID = guid;

				break; 
			}
		}
	}
	// SET DEFAULT STANDARD / FORMAT
	// 
	if( FALSE == SetFormat( 0x34363248, 1920, 1080, 24, 29.970 ) ) {
	
		if( FALSE == SetFormat( 0x34363258, 960, 540, 24, 29.970 ) ) {

			return FALSE;
		}
	}
	// QUERY VIDEO COMPRESSION PROPERTY
	// 
	if( SUCCEEDED(m_pCommonCaptureGraphBuilder2->FindInterface( NULL, NULL, m_pCaptureSourceBaseFilter, IID_IAMVideoCompression, (VOID **)(&m_pAMVideoCompression) )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create( FindInterface(IID_IAMVideoCompression) )" ); }

	// COMPLETE
	// 
	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::Create()" );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::GetFormat( ULONG *  pColorSpaceType,
										
												ULONG *  pWidth,
												 
												ULONG *  pHeight,
												 
												ULONG *  pBitCount,
												 
												double * pFrameRate )
{
	AM_MEDIA_TYPE * pmt = NULL;

	if( NULL == m_pAMStreamConfig ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetFormat( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMStreamConfig->GetFormat( &pmt )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetFormat( IAMStreamConfig::GetFormat() ) ERROR!!" ); return FALSE; }

	ULONG  cso = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biCompression;

	ULONG  cxo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biWidth;

	ULONG  cyo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biHeight;

	ULONG  czo = ((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biBitCount;

	double fps = (double)(10000000.0 / ((VIDEOINFOHEADER *)(pmt->pbFormat))->AvgTimePerFrame);

	if( pColorSpaceType ) { *pColorSpaceType = cso; }

	if( pWidth ) { *pWidth = cxo; }

	if( pHeight ) { *pHeight = cyo; }

	if( pBitCount ) { *pBitCount = czo; }

	if( pFrameRate ) { *pFrameRate = fps; }

	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetFormat( %08X  %d  %d  %d  %2.6f )", cso, cxo, cyo, czo, fps );

	DeleteMediaType( pmt );

	pmt = NULL;

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::SetFormat( ULONG  nColorSpaceType,
										 
												ULONG  nWidth,

												ULONG  nHeight,
												 
												ULONG  nBitCount,
												 
												double dFrameRate )
{
	ULONG           nStandard = 0x00000000;

	OAFilterState   eState = GetState();

	AM_MEDIA_TYPE * pmt = NULL;

	GUID			guid = { 0x00000000, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xAA, 0x00, 0x38, 0x9B, 0x71 };

	if( FALSE == Stop() ) { return FALSE; }

	if( FALSE == GetStandard( &nStandard ) ) { return FALSE; }

	if( NULL == m_pAMStreamConfig ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetFormat( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMStreamConfig->GetFormat( &pmt )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetFormat( IAMStreamConfig::GetFormat() ) ERROR!!" ); return FALSE; }

	if( nStandard & SUPPORTED_ANALOG_VIDEO_STANDARDS_50HZ ) {

		if( dFrameRate == 24.000000 ) { dFrameRate = 25.000000; }

		if( dFrameRate == 29.970000 ) { dFrameRate = 25.000000; }

		if( dFrameRate == 30.000000 ) { dFrameRate = 25.000000; }

		if( dFrameRate == 59.940000 ) { dFrameRate = 50.000000; }

		if( dFrameRate == 60.000000 ) { dFrameRate = 50.000000; }

		if( nHeight    ==       480 ) { nHeight    =       576; }

		if( nHeight    ==       240 ) { nHeight    =       288; }

		if( nHeight    ==       120 ) { nHeight    =       144; }
	}
	if( nStandard & SUPPORTED_ANALOG_VIDEO_STANDARDS_60HZ ) {

		if( dFrameRate == 24.000000 ) { dFrameRate = 29.970000; }

		if( dFrameRate == 25.000000 ) { dFrameRate = 29.970000; }

		if( dFrameRate == 30.000000 ) { dFrameRate = 29.970000; }

		if( dFrameRate == 50.000000 ) { dFrameRate = 59.940000; }

		if( dFrameRate == 60.000000 ) { dFrameRate = 59.940000; }

		if( nHeight    ==       576 ) { nHeight    =       480; }

		if( nHeight    ==       288 ) { nHeight    =       240; }

		if( nHeight    ==       144 ) { nHeight    =       120; }
	}
	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biCompression = guid.Data1 = nColorSpaceType;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biHeight = nHeight;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biWidth = nWidth;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biBitCount = (USHORT)(nBitCount);

	((VIDEOINFOHEADER *)(pmt->pbFormat))->bmiHeader.biSizeImage = nWidth * nHeight * nBitCount / 8;

	((VIDEOINFOHEADER *)(pmt->pbFormat))->AvgTimePerFrame = (ULONG)(INT)(10000000.0 / dFrameRate);

	((VIDEOINFOHEADER *)(pmt->pbFormat))->dwBitRate = (ULONG)(INT)(nWidth * nHeight * nBitCount * dFrameRate * 8);

	pmt->subtype = guid;

	// DISCONNECT FILTERS
	//
	if( FALSE == DisconnectFilters( m_pCaptureSourceBaseFilter, m_pSampleGrabberBaseFilter ) ) { ; }

	// CHANGE FORMAT
	//
	if( FAILED(m_pAMStreamConfig->SetFormat( pmt )) ) { 
		
		SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetFormat( IAMStreamConfig::SetFormat() ) ERROR!!" );
		
		goto EXIT_SETFORMAT;
	}

	// CONNECT FILTERS
	//
	if( FALSE == ConnectFilters( m_pCaptureSourceBaseFilter, m_pSampleGrabberBaseFilter ) ) goto EXIT_SETFORMAT;

	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetFormat( %08X  %d  %d  %d  %2.6f )", nColorSpaceType, nWidth, nHeight, nBitCount, dFrameRate );

	DeleteMediaType( pmt );

	pmt = NULL;

	if( FALSE == GetFormat( NULL, NULL, NULL, NULL, NULL ) ) { return FALSE; }

	if( eState == State_Running ) {

		return Run();
	}
	return TRUE;

EXIT_SETFORMAT:

	DeleteMediaType( pmt );

	pmt = NULL;

	return FALSE;
}

BOOL CAnalogDeviceVideoEncoderGraph::GetStandard( ULONG * pStandard )
{
	if( NULL == pStandard ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetStandard( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pAMAnalogVideoDecoder ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetStandard( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMAnalogVideoDecoder->get_TVFormat( (LONG *)(pStandard) )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetStandard( IAMAnalogVideoDecoder::get_TVFormat() ) ERROR!!" ); return FALSE; }

	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetStandard( %08X )", *pStandard );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::SetStandard( ULONG nStandard )
{
	if( NULL == m_pAMAnalogVideoDecoder ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetStandard( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMAnalogVideoDecoder->put_TVFormat( nStandard )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetStandard( IAMAnalogVideoDecoder::put_TVFormat() ) ERROR!!" ); return FALSE; }

	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetStandard( %08X )", nStandard );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::GetLock( ULONG * pLock )
{
	if( NULL == pLock ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetLock( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pAMAnalogVideoDecoder ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetLock( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pAMAnalogVideoDecoder->get_HorizontalLocked( (LONG *)(pLock) )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetLock( IQualProp::get_HorizontalLocked() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetLock( %d )", *pLock );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( ULONG nProperty, ULONG * pValue )
{
	DWORD cbBytes = 0x00000000;

	if( NULL == pValue ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pAMVideoCompression ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( NULL ) ERROR!!" ); return FALSE; }

	if( nProperty == 0x00000000 ) { // KEY.FRAME.RATE

		if( FAILED(m_pAMVideoCompression->get_KeyFrameRate( (LONG *)(pValue) )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( IAMVideoCompression::get_KeyFrameRate() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000001 ) { // QUALITY

		double fQuality = 0.0f;

		if( FAILED(m_pAMVideoCompression->get_Quality( &fQuality )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( IAMVideoCompression::get_Quality() ) ERROR!!" ); 

			return FALSE;
		}
		else {

		   *pValue = (ULONG)(fQuality * 10000.0f);
		}
	}
	if( nProperty == 0x00000003 ) { // BIT.RATE.MODE

		if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 407, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( m_pKsPropertySet::Get() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000004 ) { // BIT.RATE

		if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 403, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( m_pKsPropertySet::Get() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000008 ) { // POST.RESOLUTION

		if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 401, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( m_pKsPropertySet::Get() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000009 ) { // POST.SKIP.FRAMERATE

		if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 402, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( m_pKsPropertySet::Get() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x0000000D ) { // POST.AVG.FRAMERATE

		if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 422, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( m_pKsPropertySet::Get() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x0000000B ) { // PROFILE

		if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 412, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( m_pKsPropertySet::Get() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x0000000C ) { // ASPECT.RATIO

		if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, 413, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( m_pKsPropertySet::Get() ) ERROR!!" ); 

			return FALSE;
		}
	}
	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetVideoCompressionProperty( %d  %d )", nProperty, *pValue );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( ULONG nProperty, ULONG nValue )
{
	UINT nSize = sizeof(ULONG);

	if( NULL == m_pAMVideoCompression ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( NULL ) ERROR!!" ); return FALSE; }

	if( nProperty == 0x00000000 ) { // KEY.FRAME.RATE

		if( FAILED(m_pAMVideoCompression->put_KeyFrameRate( nValue )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( IAMVideoCompression::put_KeyFrameRate() ) ERROR!!\n" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000001 ) { // QUALITY

		double fQuality = nValue;

		fQuality /= 10000.0f;

		if( FAILED(m_pAMVideoCompression->put_Quality( fQuality )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( IAMVideoCompression::put_Quality() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000002 ) { // OVERRIDE.KEY.FRAME 

		if( FAILED(m_pAMVideoCompression->put_KeyFrameRate( 0 )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( IAMVideoCompression::put_KeyFrameRate() ) ERROR!!\n" ); 

			return FALSE;
		}
	//	if( FAILED(m_pAMVideoCompression->OverrideKeyFrame( nValue )) ) { 
	//			
	//		SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( IAMVideoCompression::OverrideKeyFrame() ) ERROR!!" ); 
	//
	//		return FALSE;
	//	}
	}
	if( nProperty == 0x00000003 ) { // BIT.RATE.MODE

		if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, 407, NULL, 0, &nValue, nSize )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( m_pKsPropertySet::Set() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000004 ) { // BIT.RATE

		if( FAILED( m_pKsPropertySet->Set( m_sKsPropertySetGUID, 403, NULL, 0, &nValue, nSize )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( m_pKsPropertySet::Set() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000008 ) { // POST.RESOLUTION

		if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, 401, NULL, 0, &nValue, nSize )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( m_pKsPropertySet::Set() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x00000009 ) { // POST.SKIP.FRAMERATE

		if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, 402, NULL, 0, &nValue, nSize )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( m_pKsPropertySet::Set() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x0000000D ) { // POST.AVG.FRAMERATE

		if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, 422, NULL, 0, &nValue, nSize )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( m_pKsPropertySet::Set() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x0000000B ) { // PROFILE

		if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, 412, NULL, 0, &nValue, nSize )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( m_pKsPropertySet::Set() ) ERROR!!" ); 

			return FALSE;
		}
	}
	if( nProperty == 0x0000000C ) { // ASPECT.RATIO

		if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, 413, NULL, 0, &nValue, nSize )) ) { 
				
			SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( m_pKsPropertySet::Set() ) ERROR!!" ); 

			return FALSE;
		}
	}
	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetVideoCompressionProperty( %d  %d )", nProperty, nValue );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::GetCustomPropertyEx( ULONG nProperty, BYTE * pValue, ULONG nBytes )
{
	DWORD cbBytes = nBytes;

	if( NULL == pValue ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomPropertyEx( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomPropertyEx( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, nProperty, NULL, 0, pValue, nBytes, &cbBytes )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomPropertyEx( IKsPropertySet::Get() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomPropertyEx( %d  %d )", nProperty, nBytes );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::SetCustomPropertyEx( ULONG nProperty, BYTE * pValue, ULONG nBytes )
{
	if( NULL == pValue ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetCustomPropertyEx( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetCustomPropertyEx( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, nProperty, NULL, 0, pValue, nBytes )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetCustomPropertyEx( IKsPropertySet::Set() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetCustomPropertyEx( %d  %d )", nProperty, nBytes );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::GetCustomProperty( ULONG nProperty, ULONG * pValue )
{
	DWORD cbBytes = 0x00000000;

	if( NULL == pValue ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomProperty( NULL ) ERROR!!" ); return FALSE; }

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomProperty( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pKsPropertySet->Get( m_sKsPropertySetGUID, nProperty, NULL, 0, pValue, sizeof(ULONG), &cbBytes )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomProperty( IKsPropertySet::Get() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::GetCustomProperty( %d  %d )", nProperty, *pValue );

	return TRUE;
}

BOOL CAnalogDeviceVideoEncoderGraph::SetCustomProperty( ULONG nProperty, ULONG nValue )
{
	UINT nSize = sizeof(ULONG);

	if( NULL == m_pKsPropertySet ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetCustomProperty( NULL ) ERROR!!" ); return FALSE; }

	if( FAILED(m_pKsPropertySet->Set( m_sKsPropertySetGUID, nProperty, NULL, 0, &nValue, nSize )) ) { SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetCustomProperty( IKsPropertySet::Set() ) ERROR!!" ); return FALSE; }

//	SC_DEBUG( "CAnalogDeviceVideoEncoderGraph::SetCustomProperty( %d  %d )", nProperty, nValue );

	return TRUE;
}

